function y = erfcScalar(x)
%ERFC  Complementary error function.
%   Y = ERFC(X) is the complementary error function for each element
%   of X.  X must be real.  The complementary error function is
%   defined as:
%
%     erfc(x) = 2/sqrt(pi) * integral from x to inf of exp(-t^2) dt.
%             = 1 - erf(x).
%
%   See also ERF, ERFCX, ERFINV.

%   Ref: Abramowitz & Stegun, Handbook of Mathematical Functions, sec. 7.1.
%   Copyright 1984-2002 The MathWorks, Inc. 
%   $Revision: 5.12 $  $Date: 2002/04/09 00:29:47 $

% Derived from a FORTRAN program by W. J. Cody.

if ~isreal(x), error('X must be real.'); end
y = erfcoreScalar(x,1);
